/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.viewer;

import filenet.sim.apps.viewer.VWSIMAnimatorCore;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWSplashWindow;
import java.net.URL;
import javax.swing.JOptionPane;

public class VWSIMAnimatorApplet
extends VWBaseAppLauncherApplet
implements IVWSplashWindowListener {
    private VWSplashWindow m_splashWindow = null;
    private VWSIMAnimatorCore m_animatorCore = null;

    public void init() {
        String animatorCodeBase = null;
        URL codebase = null;
        String title = null;
        try {
            super.init();
            this.m_splashWindow = new VWSplashWindow(null);
            title = VWIDMBaseFactory.instance().getVWString(13).toString();
            animatorCodeBase = this.getParameter("animatorCodeBase");
            if (animatorCodeBase != null) {
                codebase = new URL("http", this.m_sessionInfo.getProperty("hostName"), animatorCodeBase);
            }
            if (codebase != null) {
                IVWIDMFactoryProperties properties = VWIDMBaseFactory.instance().getProperties();
                properties.setProperty("hostName", this.m_sessionInfo.getProperty("hostName"));
                properties.setProperty("baseURL", codebase.toString());
                properties.setProperty("applet", null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            this.setEnabled(false);
            this.setVisible(false);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), title, 0, null);
            this.abort();
        }
    }

    public void start() {
        if (this.m_splashWindow != null) {
            this.m_splashWindow.start(this, 250);
        }
    }

    public void destroy() {
        try {
            if (this.m_splashWindow != null) {
                this.m_splashWindow.setVisible(false);
            }
            if (this.m_animatorCore != null) {
                this.m_animatorCore.doExit();
                this.m_animatorCore = null;
            }
            VWSIMHelp.cleanUp(this);
            super.destroy();
            System.runFinalization();
            System.gc();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        if (this.m_animatorCore != null) {
            return;
        }
        try {
            if (!this.m_sessionInfo.verifyLogon(null)) {
                this.abort();
                return;
            }
            if (this.m_splashWindow != null) {
                this.m_splashWindow.show();
            }
            VWSIMHelp.init(this);
            this.m_animatorCore = new VWSIMAnimatorCore();
            this.m_animatorCore.setSplashWindow(this.m_splashWindow);
            this.m_animatorCore.init(this.m_sessionInfo);
            this.m_animatorCore.setSplashWindow(null);
            this.m_splashWindow = null;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void childWindowClosed() {
    }

    protected void abort() {
        super.abort();
    }
}

